<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pembayaran Berhasil</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #4F46E5; color: white; padding: 20px; text-align: center; }
        .content { background: #f9f9f9; padding: 20px; }
        .footer { background: #333; color: white; padding: 15px; text-align: center; font-size: 12px; }
        .success { background: #10B981; color: white; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .info-box { background: white; padding: 15px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #4F46E5; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Pembayaran Berhasil!</h1>
            <p>Klinik Kecantikan</p>
        </div>
        
        <div class="content">
            <div class="success">
                <h2>✅ Pembayaran Anda telah berhasil diproses!</h2>
            </div>
            
            <p>Halo <strong>{{ $patient->name }}</strong>,</p>
            
            <p>Terima kasih! Pembayaran untuk pendaftaran pemeriksaan Anda telah berhasil diproses.</p>
            
            <div class="info-box">
                <h3>Detail Pendaftaran:</h3>
                <ul>
                    <li><strong>No. Registrasi:</strong> {{ $registration->registration_number }}</li>
                    <li><strong>Tanggal Pemeriksaan:</strong> {{ $registration->exam_date->format('d/m/Y') }}</li>
                    <li><strong>Jenis Pemeriksaan:</strong> {{ ucfirst($registration->exam_type) }}</li>
                    <li><strong>Jumlah Pembayaran:</strong> Rp {{ number_format($payment->amount, 0, ',', '.') }}</li>
                    <li><strong>Tanggal Bayar:</strong> {{ $payment->paid_at->format('d/m/Y H:i') }}</li>
                </ul>
            </div>
            
            <h3>Langkah Selanjutnya:</h3>
            <ol>
                <li>Datang ke klinik pada tanggal yang telah ditentukan</li>
                <li>Bawa kartu identitas (KTP) yang valid</li>
                <li>Datang 15 menit sebelum jadwal pemeriksaan</li>
                <li>Hasil pemeriksaan akan tersedia di portal pasien setelah selesai</li>
            </ol>
            
            <p><strong>Alamat Klinik:</strong><br>
            Jl. Contoh No. 123<br>
            Jakarta Selatan 12345<br>
            Telepon: (021) 1234-5678</p>
            
            <p>Jika ada pertanyaan, silakan hubungi kami.</p>
            
            <p>Terima kasih atas kepercayaan Anda!</p>
        </div>
        
        <div class="footer">
            <p>&copy; {{ date('Y') }} Klinik Kecantikan. Semua hak dilindungi.</p>
        </div>
    </div>
</body>
</html>
